#include "SMIplImage.h"

#include <iostream>

using namespace std;

TSMImage::TSMImage( const CvSize size, const int _depth, const int _nChannels, TVoidAllocator _void_alloc)
	: timestamp( -1), userCount( 0), width( size.width), height( size.height), depth( _depth), nChannels( _nChannels), alloc( _void_alloc), imageData( NULL), byteDepth( 0)
{	
	// get number of bytes per pixel
	if( depth == IPL_DEPTH_8U || depth == IPL_DEPTH_8S ){
		byteDepth = 1; 
	} else if( depth == IPL_DEPTH_16S || depth == IPL_DEPTH_16U){
		byteDepth = 2;
	} else if( depth == IPL_DEPTH_32F || depth == IPL_DEPTH_32S){
		byteDepth = 4;
	} else if( depth == IPL_DEPTH_64F){
		byteDepth = 2;
	} else {
		cerr << "Error: Unknown image depth when constructing IplImage in shared memory (TSMImage)." << endl;
		throw( std::string( "Error: Unknown image depth when constructing IplImage in shared memory (TSMImage)."));
	}

	IplImage *tempImage = cvCreateImageHeader( cvSize( width, height), depth, nChannels);

	imageData = alloc.allocate( tempImage->imageSize);
	cvReleaseImageHeader( & tempImage);
}

TSMImage::~TSMImage()
{
	alloc.deallocate( imageData, 0);
}

IplImage * TSMImage::createIplImage()
{
	IplImage *tempImage = cvCreateImageHeader( cvSize( width, height), depth, nChannels);

	tempImage->imageData = imageData.get();
	tempImage->imageDataOrigin = imageData.get();

	return tempImage;
}

int TSMImage::use()
{
	return ++userCount;
}
int TSMImage::ret()
{
	return --userCount;
}
int TSMImage::getUserCount()
{
	return userCount;
}


long long TSMImage::getTS()
{
	return timestamp;
}
void TSMImage::setTS( long long ts)
{
	timestamp = ts;
}